--
-- Table structure for table `follow_up`
--

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_media_gallery`
--

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_menus`
--

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `front_cms_menus`
--

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES
(1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 12:54:49'),
(2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 12:54:55');

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_menu_items`
--

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_pages`
--

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `front_cms_pages`
--

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES
(1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>home page</p>', '0000-00-00', 1, NULL, 'no', '2018-07-11 16:04:33'),
(2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<p>\r\n[form-builder:complain]</p>', '0000-00-00', 1, 1, 'no', '2018-05-09 13:14:34'),
(54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 12:46:04'),
(76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<title></title>\r\n<section class=\"contact\">\r\n<div class=\"container spacet50 spaceb50\">\r\n<div class=\"row\">\r\n<div class=\"col-md-12 col-sm-12\">[form-builder:contact_us]<!--./row--></div>\r\n<!--./col-md-12--></div>\r\n<!--./row--></div>\r\n<!--./container--></section>', '0000-00-00', 0, NULL, 'no', '2018-07-11 16:03:41');

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_page_contents`
--

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_programs`
--

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_program_photos`
--

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `front_cms_settings`
--

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `general_calls`
--

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_dureation` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `glaccount_types`
--

CREATE TABLE `glaccount_types` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `glaccount_types`
--

INSERT INTO `glaccount_types` (`id`, `name`, `description`, `active`) VALUES
(1, 'Income', 'Income', 1);

-- --------------------------------------------------------

--
-- Table structure for table `glledger_account`
--

CREATE TABLE `glledger_account` (
  `id` int(11) NOT NULL,
  `date` varchar(50) NOT NULL,
  `gl_code` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(200) NOT NULL,
  `account_type` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `glledger_account`
--

INSERT INTO `glledger_account` (`id`, `date`, `gl_code`, `name`, `description`, `account_type`, `active`) VALUES
(1, '2023-01-04 12:12:58am', '1000', 'Income', 'Admin-Income', 'Income', 1);

-- --------------------------------------------------------

--
-- Table structure for table `glsub_account`
--

CREATE TABLE `glsub_account` (
  `id` int(11) NOT NULL,
  `date` varchar(100) NOT NULL,
  `glsub_code` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `account_type` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `glsub_account`
--

INSERT INTO `glsub_account` (`id`, `date`, `glsub_code`, `name`, `description`, `account_type`, `active`) VALUES
(1, '2023-01-04 10:12:47am', '100', 'Salarries', 'Salarries', 'Income', 1);

-- --------------------------------------------------------

--
-- Table structure for table `grades`
--

CREATE TABLE `grades` (
  `id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `point` float(10,1) DEFAULT NULL,
  `mark_from` float(10,2) DEFAULT NULL,
  `mark_upto` float(10,2) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `homework`
--

CREATE TABLE `homework` (
  `id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `homework_date` date NOT NULL,
  `submit_date` date NOT NULL,
  `staff_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `description` varchar(500) NOT NULL,
  `create_date` date NOT NULL,
  `document` varchar(200) NOT NULL,
  `created_by` int(11) NOT NULL,
  `evaluated_by` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `homework`
--

INSERT INTO `homework` (`id`, `class_id`, `section_id`, `homework_date`, `submit_date`, `staff_id`, `subject_id`, `description`, `create_date`, `document`, `created_by`, `evaluated_by`) VALUES
(1, 9, 13, '2022-11-24', '2022-11-24', 1, 5, '<p>English home work<br></p>', '2022-11-24', 'Chapter 4 Results.docx', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `homework_evaluation`
--

CREATE TABLE `homework_evaluation` (
  `id` int(11) NOT NULL,
  `homework_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `home_currency`
--

CREATE TABLE `home_currency` (
  `id` int(11) NOT NULL,
  `date` varchar(50) NOT NULL,
  `currencycode` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(50) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `home_currency`
--

INSERT INTO `home_currency` (`id`, `date`, `currencycode`, `name`, `description`, `active`) VALUES
(2, '21-12-2022 11:07:50am', 'zwl', 'ZWL', 'zwl', 1),
(7, '26-10-2022 12:34:56pm', 'USD', 'USD', 'United states dollars', 1);

-- --------------------------------------------------------

--
-- Table structure for table `hostel`
--

CREATE TABLE `hostel` (
  `id` int(11) NOT NULL,
  `hostel_name` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `intake` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hostel_rooms`
--

CREATE TABLE `hostel_rooms` (
  `id` int(11) NOT NULL,
  `hostel_id` int(11) DEFAULT NULL,
  `room_type_id` int(11) DEFAULT NULL,
  `room_no` varchar(200) DEFAULT NULL,
  `no_of_bed` int(11) DEFAULT NULL,
  `cost_per_bed` float(10,2) DEFAULT 0.00,
  `title` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `id_card`
--

CREATE TABLE `id_card` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `school_name` varchar(100) NOT NULL,
  `school_address` varchar(500) NOT NULL,
  `background` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `sign_image` varchar(100) NOT NULL,
  `header_color` varchar(100) NOT NULL,
  `enable_admission_no` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_student_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_class` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_fathers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_mothers_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `id_card`
--

INSERT INTO `id_card` (`id`, `title`, `school_name`, `school_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_admission_no`, `enable_student_name`, `enable_class`, `enable_fathers_name`, `enable_mothers_name`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `status`) VALUES
(1, 'Sample Student Identity Card', 'Mount Carmel School', '110 Kings Street, CA  Phone: 456542 Email: mount@gmail.com', 'samplebackground12.png', 'samplelogo12.png', 'samplesign12.png', '#595959', 1, 1, 1, 1, 0, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `income`
--

CREATE TABLE `income` (
  `id` int(11) NOT NULL,
  `inc_head_id` varchar(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL,
  `documents` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `income`
--

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `updated_at`, `documents`) VALUES
(1, '1', 'Broiler chickens', 'inv123', '2022-11-24', 6, '', 'yes', 'no', '2022-11-24 06:38:36', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `income_head`
--

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `income_head`
--

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`, `updated_at`) VALUES
(1, 'POULTRY', 'POULTRY PROJECT', 'yes', 'no', '2022-11-24 06:36:12', '');

-- --------------------------------------------------------

--
-- Table structure for table `item`
--

CREATE TABLE `item` (
  `id` int(11) NOT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL,
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item`
--

INSERT INTO `item` (`id`, `item_category_id`, `name`, `item_photo`, `description`, `created_at`, `updated_at`, `item_store_id`, `item_supplier_id`, `quantity`, `date`) VALUES
(1, 1, 'Mazoe 2liters Orange crush', NULL, 'Mazoe 2liters Orange crush', '2022-11-24 05:37:41', '', NULL, NULL, 0, '0000-00-00'),
(2, 1, 'White bread bakers Inn', NULL, 'White bread bakers Inn', '2022-11-24 05:38:01', '', NULL, NULL, 0, '0000-00-00');

-- --------------------------------------------------------

--
-- Table structure for table `item_category`
--

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_category`
--

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`, `updated_at`) VALUES
(1, 'Groceries', 'yes', 'Groceries', '2022-11-24 05:35:31', '');

-- --------------------------------------------------------

--
-- Table structure for table `item_issue`
--

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL,
  `issue_to` varchar(100) DEFAULT NULL,
  `issue_from` varchar(100) NOT NULL,
  `received_by` varchar(100) NOT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` varchar(10) DEFAULT 'no'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_issue`
--

INSERT INTO `item_issue` (`id`, `issue_to`, `issue_from`, `received_by`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES
(2, 'Canteen', '', 'king', 'dane', '2022-11-25', '0000-00-00', 1, 2, 3, 'mazoe', 1, '2022-11-24 22:28:08', 'no'),
(3, 'Canteen', 'Stores', 'mum', 'ken', '2022-11-25', '0000-00-00', 1, 1, 7, 'hello', 1, '2022-11-24 22:44:39', 'no');

-- --------------------------------------------------------

--
-- Table structure for table `item_stock`
--

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_stock`
--

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES
(1, 1, 1, '+', 1, 12, '1970-01-01', NULL, '', 'yes', '2022-11-24 05:38:41'),
(2, 2, 1, '+', 1, 6, '1970-01-01', NULL, '', 'yes', '2022-11-24 05:39:14');

-- --------------------------------------------------------

--
-- Table structure for table `item_store`
--

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_store`
--

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`) VALUES
(1, 'Stores', 'sto', 'Stores'),
(2, 'Canteen', 'cn', 'Canteen');

-- --------------------------------------------------------

--
-- Table structure for table `item_supplier`
--

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `item_supplier`
--

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES
(1, 'Cash Supplier', '07751213114', 'cashsupplier@gmail.com', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `journal`
--

CREATE TABLE `journal` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(100) NOT NULL,
  `date` varchar(20) NOT NULL,
  `cashbook` varchar(100) NOT NULL,
  `description` varchar(400) NOT NULL,
  `account` varchar(200) NOT NULL,
  `module` varchar(100) NOT NULL,
  `receipt` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `debit` varchar(100) NOT NULL,
  `credit` varchar(100) NOT NULL,
  `balance` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `journal`
--

INSERT INTO `journal` (`id`, `date_captured`, `date`, `cashbook`, `description`, `account`, `module`, `receipt`, `currency`, `debit`, `credit`, `balance`, `active`) VALUES
(18, '22-11-2022 11:15:21am', '2022-11-22', 'CBZ-USD', 'me please', 'DANIEL', 'Supplier', 'd33', '', '240', '0', '1222', 1),
(19, '22-11-2022 11:24:23am', '2022-11-23', 'CBZ-USD', 'correct', 'r131292e', 'Supplier', 'rea', '', '0', '122', '-122', 1);

-- --------------------------------------------------------

--
-- Table structure for table `journal_accounts`
--

CREATE TABLE `journal_accounts` (
  `id` int(11) NOT NULL,
  `journal_accounts` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `description` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `journal_accounts`
--

INSERT INTO `journal_accounts` (`id`, `journal_accounts`, `currency`, `description`, `active`) VALUES
(1, 'CBZ-USD', 'USD', 'CBZ-USD', 1);

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `id` int(11) NOT NULL,
  `language` varchar(50) DEFAULT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `code` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` (`id`, `language`, `is_deleted`, `is_active`, `code`, `created_at`, `updated_at`) VALUES
(1, 'Azerbaijan', 'no', 'no', 'az', '2019-03-25 12:27:01', '0000-00-00 00:00:00'),
(2, 'Albanian', 'no', 'no', 'sq', '2019-03-25 12:25:01', '0000-00-00 00:00:00'),
(3, 'Amharic', 'no', 'no', 'am', '2019-03-25 12:25:16', '0000-00-00 00:00:00'),
(4, 'English', 'no', 'no', 'en', '2019-03-25 12:32:05', '0000-00-00 00:00:00'),
(5, 'Arabic', 'no', 'no', 'ar', '2019-03-25 12:26:50', '0000-00-00 00:00:00'),
(7, 'Afrikaans', 'no', 'no', 'af', '2019-03-25 12:24:33', '0000-00-00 00:00:00'),
(8, 'Basque', 'no', 'no', 'eu', '2019-03-25 12:27:41', '0000-00-00 00:00:00'),
(11, 'Bengali', 'no', 'no', 'bn', '2019-03-25 12:27:52', '0000-00-00 00:00:00'),
(13, 'Bosnian', 'no', 'no', 'bs', '2019-03-25 12:28:03', '0000-00-00 00:00:00'),
(14, 'Welsh', 'no', 'no', 'cy', '2019-03-25 12:46:16', '0000-00-00 00:00:00'),
(15, 'Hungarian', 'no', 'no', 'hu', '2019-03-25 12:36:29', '0000-00-00 00:00:00'),
(16, 'Vietnamese', 'no', 'no', 'vi', '2019-03-25 12:46:06', '0000-00-00 00:00:00'),
(17, 'Haitian (Creole)', 'no', 'no', 'ht', '2019-03-25 12:35:54', '0000-00-00 00:00:00'),
(18, 'Galician', 'no', 'no', 'gl', '2019-03-25 12:35:00', '0000-00-00 00:00:00'),
(19, 'Dutch', 'no', 'no', 'nl', '2019-03-25 12:31:52', '0000-00-00 00:00:00'),
(21, 'Greek', 'no', 'no', 'el', '2019-03-25 12:35:28', '0000-00-00 00:00:00'),
(22, 'Georgian', 'no', 'no', 'ka', '2019-03-25 12:35:10', '0000-00-00 00:00:00'),
(23, 'Gujarati', 'no', 'no', 'gu', '2019-03-25 12:35:38', '0000-00-00 00:00:00'),
(24, 'Danish', 'no', 'no', 'da', '2019-03-25 12:31:40', '0000-00-00 00:00:00'),
(25, 'Hebrew', 'no', 'no', 'he', '2019-03-25 12:36:06', '0000-00-00 00:00:00'),
(26, 'Yiddish', 'no', 'no', 'yi', '2019-03-25 12:46:34', '0000-00-00 00:00:00'),
(27, 'Indonesian', 'no', 'no', 'id', '2019-03-25 12:36:51', '0000-00-00 00:00:00'),
(28, 'Irish', 'no', 'no', 'ga', '2019-03-25 12:37:02', '0000-00-00 00:00:00'),
(29, 'Italian', 'no', 'no', 'it', '2019-03-25 12:37:11', '0000-00-00 00:00:00'),
(30, 'Icelandic', 'no', 'no', 'is', '2019-03-25 12:36:40', '0000-00-00 00:00:00'),
(31, 'Spanish', 'no', 'no', 'es', '2019-03-25 12:44:20', '0000-00-00 00:00:00'),
(33, 'Kannada', 'no', 'no', 'kn', '2019-03-25 12:37:41', '0000-00-00 00:00:00'),
(34, 'Catalan', 'no', 'no', 'ca', '2019-03-25 12:28:20', '0000-00-00 00:00:00'),
(36, 'Chinese', 'no', 'no', 'zh', '2019-03-25 12:31:19', '0000-00-00 00:00:00'),
(37, 'Korean', 'no', 'no', 'ko', '2019-03-25 12:37:55', '0000-00-00 00:00:00'),
(38, 'Xhosa', 'no', 'no', 'xh', '2019-03-25 12:46:26', '0000-00-00 00:00:00'),
(39, 'Latin', 'no', 'no', 'la', '2019-03-25 12:38:04', '0000-00-00 00:00:00'),
(40, 'Latvian', 'no', 'no', 'lv', '2019-03-25 12:38:41', '0000-00-00 00:00:00'),
(41, 'Lithuanian', 'no', 'no', 'lt', '2019-03-25 12:38:46', '0000-00-00 00:00:00'),
(43, 'Malagasy', 'no', 'no', 'mg', '2019-03-25 12:39:17', '0000-00-00 00:00:00'),
(44, 'Malay', 'no', 'no', 'ms', '2019-03-25 12:39:26', '0000-00-00 00:00:00'),
(45, 'Malayalam', 'no', 'no', 'ml', '2019-03-25 12:39:36', '0000-00-00 00:00:00'),
(46, 'Maltese', 'no', 'no', 'mt', '2019-03-25 12:39:46', '0000-00-00 00:00:00'),
(47, 'Macedonian', 'no', 'no', 'mk', '2019-03-25 12:39:06', '0000-00-00 00:00:00'),
(48, 'Maori', 'no', 'no', 'mi', '2019-03-25 12:39:55', '0000-00-00 00:00:00'),
(49, 'Marathi', 'no', 'no', 'mr', '2019-03-25 12:40:04', '0000-00-00 00:00:00'),
(51, 'Mongolian', 'no', 'no', 'mn', '2019-03-25 12:40:14', '0000-00-00 00:00:00'),
(52, 'German', 'no', 'no', 'de', '2019-03-25 12:35:20', '0000-00-00 00:00:00'),
(53, 'Nepali', 'no', 'no', 'ne', '2019-03-25 12:40:24', '0000-00-00 00:00:00'),
(54, 'Norwegian', 'no', 'no', 'no', '2019-03-25 12:40:43', '0000-00-00 00:00:00'),
(55, 'Punjabi', 'no', 'no', 'pa', '2019-03-25 12:41:20', '0000-00-00 00:00:00'),
(57, 'Persian', 'no', 'no', 'fa', '2019-03-25 12:40:57', '0000-00-00 00:00:00'),
(59, 'Portuguese', 'no', 'no', 'pt', '2019-03-25 12:41:09', '0000-00-00 00:00:00'),
(60, 'Romanian', 'no', 'no', 'ro', '2019-03-25 12:41:41', '0000-00-00 00:00:00'),
(61, 'Russian', 'no', 'no', 'ru', '2019-03-25 12:43:19', '0000-00-00 00:00:00'),
(62, 'Cebuano', 'no', 'no', '', '2017-04-06 03:08:33', '0000-00-00 00:00:00'),
(64, 'Sinhala', 'no', 'no', 'si', '2019-03-25 12:43:46', '0000-00-00 00:00:00'),
(65, 'Slovakian', 'no', 'no', '', '2017-04-06 03:08:33', '0000-00-00 00:00:00'),
(66, 'Slovenian', 'no', 'no', 'sl', '2019-03-25 12:44:07', '0000-00-00 00:00:00'),
(67, 'Swahili', 'no', 'no', 'sw', '2019-03-25 12:44:40', '0000-00-00 00:00:00'),
(68, 'Sundanese', 'no', 'no', 'su', '2019-03-25 12:44:30', '0000-00-00 00:00:00'),
(70, 'Thai', 'no', 'no', 'th', '2019-03-25 12:45:29', '0000-00-00 00:00:00'),
(71, 'Tagalog', 'no', 'no', 'tl', '2019-03-25 12:45:00', '0000-00-00 00:00:00'),
(72, 'Tamil', 'no', 'no', 'ta', '2019-03-25 12:45:09', '0000-00-00 00:00:00'),
(74, 'Telugu', 'no', 'no', 'te', '2019-03-25 12:45:18', '0000-00-00 00:00:00'),
(75, 'Turkish', 'no', 'no', 'tr', '2019-03-25 12:45:36', '0000-00-00 00:00:00'),
(77, 'Uzbek', 'no', 'no', 'uz', '2019-03-25 12:45:56', '0000-00-00 00:00:00'),
(79, 'Urdu', 'no', 'no', 'ur', '2019-03-25 12:45:47', '0000-00-00 00:00:00'),
(80, 'Finnish', 'no', 'no', 'fi', '2019-03-25 12:34:34', '0000-00-00 00:00:00'),
(81, 'French', 'no', 'no', 'fr', '2019-03-25 12:34:46', '0000-00-00 00:00:00'),
(82, 'Hindi', 'no', 'no', 'hi', '2019-03-25 12:36:19', '0000-00-00 00:00:00'),
(84, 'Czech', 'no', 'no', 'cs', '2019-03-25 12:31:30', '0000-00-00 00:00:00'),
(85, 'Swedish', 'no', 'no', 'sv', '2019-03-25 12:44:50', '0000-00-00 00:00:00'),
(86, 'Scottish', 'no', 'no', 'gd', '2019-03-25 12:43:35', '0000-00-00 00:00:00'),
(87, 'Estonian', 'no', 'no', 'et', '2019-03-25 12:34:20', '0000-00-00 00:00:00'),
(88, 'Esperanto', 'no', 'no', 'eo', '2019-03-25 12:34:12', '0000-00-00 00:00:00'),
(89, 'Javanese', 'no', 'no', 'jv', '2019-03-25 12:37:31', '0000-00-00 00:00:00'),
(90, 'Japanese', 'no', 'no', 'ja', '2019-03-25 12:37:20', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `leave_types`
--

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `libarary_members`
--

CREATE TABLE `libarary_members` (
  `id` int(11) UNSIGNED NOT NULL,
  `library_card_no` varchar(50) DEFAULT NULL,
  `member_type` varchar(50) DEFAULT NULL,
  `member_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `libarary_members`
--

INSERT INTO `libarary_members` (`id`, `library_card_no`, `member_type`, `member_id`, `is_active`, `created_at`) VALUES
(1, 'LIB001', 'student', 3, 'no', '2022-11-24 06:30:03'),
(2, 'STA-LIB001', 'teacher', 3, 'no', '2022-11-24 06:30:48');

-- --------------------------------------------------------

--
-- Table structure for table `location`
--

CREATE TABLE `location` (
  `id` int(11) NOT NULL,
  `location` varchar(200) NOT NULL,
  `department` varchar(200) NOT NULL,
  `designation` varchar(200) NOT NULL,
  `description` varchar(500) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `location`
--

INSERT INTO `location` (`id`, `location`, `department`, `designation`, `description`, `active`) VALUES
(3, 'kennedy', 'sales1', 'certificate', 'new new', 1),
(4, 'KEN', 'sales1', 'SALES ', 'NEW SALES GUY', 1),
(5, 'DANIEL', 'IT', 'Software Developer', 'Software Development', 1);

-- --------------------------------------------------------

--
-- Table structure for table `medical`
--

CREATE TABLE `medical` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(200) NOT NULL,
  `name` varchar(100) NOT NULL,
  `address` varchar(200) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(200) NOT NULL,
  `company_name` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `company_address` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `medical`
--

INSERT INTO `medical` (`id`, `date_captured`, `name`, `address`, `phone`, `email`, `company_name`, `description`, `company_address`, `active`) VALUES
(1, '09-11-2022 09:26:48am', 'dd1', 'oo', 'dd', 'oo@gmail.com', 'oo', 'oo', 'oo', 1);

-- --------------------------------------------------------

--
-- Table structure for table `medical_details`
--

CREATE TABLE `medical_details` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(20) NOT NULL,
  `student_id` varchar(200) NOT NULL,
  `doctor` varchar(200) NOT NULL,
  `allergy` varchar(200) NOT NULL,
  `period` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `description` varchar(500) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `medical_details`
--

INSERT INTO `medical_details` (`id`, `date_captured`, `student_id`, `doctor`, `allergy`, `period`, `status`, `description`, `active`) VALUES
(1, '09-11-2022 10:13:55a', 'c17131292e', 'dd1', 'ashma', '3 months', 'sick', 'sick', 1);

-- --------------------------------------------------------

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` int(11) NOT NULL,
  `title` varchar(200) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `is_class` int(10) NOT NULL DEFAULT 0,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `notification_roles`
--

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `notification_roles`
--

INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES
(1, 1, 2, 0, '2022-11-24 06:46:11'),
(2, 1, 7, 0, '2022-11-24 06:46:11');

-- --------------------------------------------------------

--
-- Table structure for table `notification_setting`
--

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` varchar(10) DEFAULT '0',
  `is_sms` varchar(10) DEFAULT '0',
  `display_notification` int(11) NOT NULL DEFAULT 0,
  `is_notification` int(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `notification_setting`
--

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `display_notification`, `is_notification`, `created_at`) VALUES
(1, 'student_admission', '1', '0', 0, 0, '2019-04-10 12:27:50'),
(2, 'exam_result', '1', '0', 1, 0, '2019-04-10 12:27:50'),
(3, 'fee_submission', '1', '0', 1, 0, '2019-04-10 12:27:50'),
(4, 'absent_attendence', '1', '0', 1, 0, '2019-04-10 12:27:50'),
(5, 'login_credential', '1', '0', 0, 0, '2019-04-10 12:27:50');

-- --------------------------------------------------------

--
-- Table structure for table `payment_methods`
--

CREATE TABLE `payment_methods` (
  `id` int(11) NOT NULL,
  `payment_methods` varchar(100) NOT NULL,
  `description` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `payment_methods`
--

INSERT INTO `payment_methods` (`id`, `payment_methods`, `description`, `active`) VALUES
(3, 'RTGS', 'ZWL-RTGS', 1);

-- --------------------------------------------------------

--
-- Table structure for table `payment_settings`
--

CREATE TABLE `payment_settings` (
  `id` int(11) NOT NULL,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `payment_settings`
--

INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'paypal', '', '', '', '', '', '', NULL, '', '', 'yes', '2018-07-12 03:26:13', '0000-00-00 00:00:00'),
(2, 'stripe', NULL, '', '', '', NULL, NULL, NULL, '', '', 'no', '2018-07-12 03:26:26', '0000-00-00 00:00:00'),
(3, 'payu', NULL, '', '', '', NULL, NULL, NULL, '', '', 'no', '2018-07-12 03:26:35', '0000-00-00 00:00:00'),
(4, 'ccavenue', NULL, '', '', '', NULL, NULL, NULL, '', '', 'no', '2018-07-12 03:26:45', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `payslip_allowance`
--

CREATE TABLE `payslip_allowance` (
  `id` int(11) NOT NULL,
  `payslip_id` int(11) NOT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `cal_type` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `payslip_allowance`
--

INSERT INTO `payslip_allowance` (`id`, `payslip_id`, `allowance_type`, `amount`, `staff_id`, `cal_type`) VALUES
(1, 1, 'septer', 20, 1, 'positive'),
(2, 1, 'ded', 4, 1, 'negative');

-- --------------------------------------------------------

--
-- Table structure for table `permission_category`
--

CREATE TABLE `permission_category` (
  `id` int(11) NOT NULL,
  `perm_group_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int(11) DEFAULT 0,
  `enable_add` int(11) DEFAULT 0,
  `enable_edit` int(11) DEFAULT 0,
  `enable_delete` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `permission_category`
--

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES
(1, 1, 'Student', 'student', 1, 1, 1, 1, '2018-06-22 13:47:11'),
(2, 1, 'Import Student', 'import_student', 1, 0, 0, 0, '2018-06-22 13:47:19'),
(3, 1, 'Student Categories', 'student_categories', 1, 1, 1, 1, '2018-06-22 13:47:36'),
(4, 1, 'Student Houses', 'student_houses', 1, 1, 1, 1, '2018-06-22 13:47:53'),
(5, 2, 'Collect Fees', 'collect_fees', 1, 1, 0, 1, '2018-06-22 13:51:03'),
(6, 2, 'Fees Carry Forward', 'fees_carry_forward', 1, 0, 0, 0, '2018-06-27 03:48:15'),
(7, 2, 'Fees Master', 'fees_master', 1, 1, 1, 1, '2018-06-27 03:48:57'),
(8, 2, 'Fees Group', 'fees_group', 1, 1, 1, 1, '2018-06-22 13:51:46'),
(9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 13:53:21'),
(10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 13:52:44'),
(11, 3, 'Search Income', 'search_income', 1, 0, 0, 0, '2018-06-22 13:53:00'),
(12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 13:54:06'),
(13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 13:53:47'),
(14, 4, 'Search Expense', 'search_expense', 1, 0, 0, 0, '2018-06-22 13:54:13'),
(15, 5, 'Student Attendance', 'student_attendance', 1, 1, 1, 0, '2018-06-22 13:54:49'),
(16, 5, 'Student Attendance Report', 'student_attendance_report', 1, 0, 0, 0, '2018-06-22 13:54:26'),
(17, 6, 'Exam', 'exam', 1, 1, 1, 1, '2018-06-22 13:56:02'),
(19, 6, 'Marks Register', 'marks_register', 1, 1, 1, 0, '2018-06-22 13:56:19'),
(20, 6, 'Marks Grade', 'marks_grade', 1, 1, 1, 1, '2018-06-22 13:55:25'),
(21, 7, 'Class Timetable', 'class_timetable', 1, 1, 1, 0, '2018-06-22 14:01:36'),
(22, 7, 'Assign Subject', 'assign_subject', 1, 1, 1, 1, '2018-06-22 14:01:57'),
(23, 7, 'Subject', 'subject', 1, 1, 1, 1, '2018-06-22 14:02:17'),
(24, 7, 'Class', 'class', 1, 1, 1, 1, '2018-06-22 14:02:35'),
(25, 7, 'Section', 'section', 1, 1, 1, 1, '2018-06-22 14:01:10'),
(26, 7, 'Promote Student', 'promote_student', 1, 0, 0, 0, '2018-06-22 14:02:47'),
(27, 8, 'Upload Content', 'upload_content', 1, 1, 0, 1, '2018-06-22 14:03:19'),
(28, 9, 'Books', 'books', 1, 1, 1, 1, '2018-06-22 14:04:04'),
(29, 9, 'Issue Return Student', 'issue_return', 1, 0, 0, 0, '2018-06-22 14:03:41'),
(30, 9, 'Add Staff Member', 'add_staff_member', 1, 0, 0, 0, '2018-07-02 15:07:00'),
(31, 10, 'Issue Item', 'issue_item', 1, 0, 0, 0, '2018-06-22 14:04:51'),
(32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-22 14:05:17'),
(33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-22 14:05:40'),
(34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-22 14:06:02'),
(35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-22 14:06:25'),
(37, 11, 'Routes', 'routes', 1, 1, 1, 1, '2018-06-22 14:09:17'),
(38, 11, 'Vehicle', 'vehicle', 1, 1, 1, 1, '2018-06-22 14:09:36'),
(39, 11, 'Assign Vehicle', 'assign_vehicle', 1, 1, 1, 1, '2018-06-27 08:09:20'),
(40, 12, 'Hostel', 'hostel', 1, 1, 1, 1, '2018-06-22 14:10:49'),
(41, 12, 'Room Type', 'room_type', 1, 1, 1, 1, '2018-06-22 14:10:27'),
(42, 12, 'Hostel Rooms', 'hostel_rooms', 1, 1, 1, 1, '2018-06-25 09:53:03'),
(43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 14:11:17'),
(44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-22 14:10:54'),
(46, 13, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-06-22 14:11:23'),
(47, 1, 'Student Report', 'student_report', 1, 0, 0, 0, '2018-07-03 14:19:36'),
(48, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2018-07-06 15:13:32'),
(49, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-07-06 15:13:53'),
(53, 15, 'Languages', 'languages', 0, 1, 0, 0, '2018-06-22 14:13:18'),
(54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 12:38:35'),
(55, 15, 'Session Setting', 'session_setting', 1, 1, 1, 1, '2018-06-22 14:14:15'),
(56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 12:38:41'),
(57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 12:38:47'),
(58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 12:38:51'),
(59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 12:38:55'),
(60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 12:38:59'),
(61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-09 07:20:06'),
(62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-09 07:20:26'),
(63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 14:16:02'),
(64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 14:16:21'),
(65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 14:17:02'),
(66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 14:17:20'),
(67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-03 12:09:34'),
(68, 2, 'Fees Group Assign', 'fees_group_assign', 1, 0, 0, 0, '2018-06-22 13:50:42'),
(69, 2, 'Fees Type', 'fees_type', 1, 1, 1, 1, '2018-06-22 13:49:34'),
(70, 2, 'Fees Discount', 'fees_discount', 1, 1, 1, 1, '2018-06-22 13:50:10'),
(71, 2, 'Fees Discount Assign', 'fees_discount_assign', 1, 0, 0, 0, '2018-06-22 13:50:17'),
(72, 2, 'Fees Statement', 'fees_statement', 1, 0, 0, 0, '2018-06-22 13:48:56'),
(73, 2, 'Search Fees Payment', 'search_fees_payment', 1, 0, 0, 0, '2018-06-22 13:50:27'),
(74, 2, 'Search Due Fees', 'search_due_fees', 1, 0, 0, 0, '2018-06-22 13:50:35'),
(75, 2, 'Balance Fees Report', 'balance_fees_report', 1, 0, 0, 0, '2018-06-22 13:48:50'),
(76, 6, 'Exam Schedule', 'exam_schedule', 1, 1, 1, 0, '2018-06-22 13:55:40'),
(77, 7, 'Assign Class Teacher', 'assign_class_teacher', 1, 1, 1, 1, '2018-06-22 14:00:52'),
(78, 17, 'Admission Enquiry', 'admission_enquiry', 1, 1, 1, 1, '2018-06-22 14:21:24'),
(79, 17, 'Follow Up Admission Enquiry', 'follow_up_admission_enquiry', 1, 1, 0, 1, '2018-06-22 14:21:39'),
(80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 14:18:58'),
(81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 14:20:57'),
(82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 14:20:21'),
(83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 14:20:04'),
(84, 17, 'Complain', 'complaint', 1, 1, 1, 1, '2018-07-03 12:10:55'),
(85, 17, 'Setup Font Office', 'setup_font_office', 1, 1, 1, 1, '2018-06-22 14:19:24'),
(86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 14:23:31'),
(87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 14:23:12'),
(88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 14:23:10'),
(89, 18, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2018-06-22 14:22:54'),
(90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 0, 1, '2018-06-22 14:22:51'),
(91, 18, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2018-06-22 14:22:34'),
(93, 19, 'Homework', 'homework', 1, 1, 1, 1, '2018-06-22 14:23:50'),
(94, 19, 'Homework Evaluation', 'homework_evaluation', 1, 1, 0, 0, '2018-06-27 06:37:21'),
(95, 19, 'Homework Report', 'homework_report', 1, 0, 0, 0, '2018-06-22 14:23:54'),
(96, 20, 'Student Certificate', 'student_certificate', 1, 1, 1, 1, '2018-07-06 14:11:07'),
(97, 20, 'Generate Certificate', 'generate_certificate', 1, 0, 0, 0, '2018-07-06 14:07:16'),
(98, 20, 'Student ID Card', 'student_id_card', 1, 1, 1, 1, '2018-07-06 14:11:28'),
(99, 20, 'Generate ID Card', 'generate_id_card', 1, 0, 0, 0, '2018-07-06 14:11:49'),
(102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 14:24:41'),
(104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 14:04:33'),
(105, 1, 'Student Parent Login Details', 'student_parent_login_details', 1, 0, 0, 0, '2018-06-22 13:48:01'),
(106, 22, 'Quick Session Change', 'quick_session_change', 1, 0, 0, 0, '2018-06-22 14:24:45'),
(107, 1, 'Disable Student', 'disable_student', 1, 0, 0, 0, '2018-06-25 09:51:34'),
(108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-02 13:47:41'),
(109, 18, 'Apply Leave', 'apply_leave', 1, 1, 1, 1, '2018-06-26 07:23:32'),
(110, 18, 'Leave Types ', 'leave_types', 1, 1, 1, 1, '2018-07-02 13:47:56'),
(111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-26 07:27:07'),
(112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-26 07:27:07'),
(113, 22, 'Fees Collection And Expense Monthly Chart', 'fees_collection_and_expense_monthly_chart', 1, 0, 0, 0, '2018-07-03 10:38:15'),
(114, 22, 'Fees Collection And Expense Yearly Chart', 'fees_collection_and_expense_yearly_chart', 1, 0, 0, 0, '2018-07-03 10:38:15'),
(115, 22, 'Monthly Fees Collection Widget', 'Monthly fees_collection_widget', 1, 0, 0, 0, '2018-07-03 10:43:35'),
(116, 22, 'Monthly Expense Widget', 'monthly_expense_widget', 1, 0, 0, 0, '2018-07-03 10:43:35'),
(117, 22, 'Student Count Widget', 'student_count_widget', 1, 0, 0, 0, '2018-07-03 10:43:35'),
(118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-03 10:43:35'),
(119, 1, 'Guardian Report', 'guardian_report', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(120, 1, 'Student History', 'student_history', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(121, 1, 'Student Login Credential', 'student_login_credential', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(122, 5, 'Attendance By Date', 'attendance_by_date', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(123, 9, 'Add Student', 'add_student', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(124, 11, 'Student Transport Report', 'student_transport_report', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(125, 12, 'Student Hostel Report', 'student_hostel_report', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(126, 15, 'User Status', 'user_status', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-03 12:12:29'),
(128, 1, 'Student Timeline', 'student_timeline', 0, 1, 0, 1, '2018-07-05 11:38:52'),
(129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-05 11:38:52'),
(130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-09 07:47:17'),
(131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-09 07:47:17');

-- --------------------------------------------------------

--
-- Table structure for table `permission_group`
--

CREATE TABLE `permission_group` (
  `id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT 0,
  `system` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `permission_group`
--

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `created_at`) VALUES
(1, 'Student Information', 'student_information', 1, 1, '2018-06-27 07:09:31'),
(2, 'Fees Collection', 'fees_collection', 1, 0, '2018-07-11 06:19:10'),
(3, 'Income', 'income', 1, 1, '2022-09-14 07:19:16'),
(4, 'Expense', 'expense', 1, 1, '2022-09-14 07:19:13'),
(5, 'Student Attendance', 'student_attendance', 1, 0, '2018-07-02 11:18:08'),
(6, 'Examination', 'examination', 1, 0, '2018-07-11 06:19:08'),
(7, 'Academics', 'academics', 1, 1, '2018-07-02 10:55:43'),
(8, 'Download Center', 'download_center', 1, 0, '2018-07-02 11:19:29'),
(9, 'Library', 'library', 1, 1, '2022-09-14 07:18:59'),
(10, 'Inventory', 'inventory', 1, 0, '2018-06-27 04:18:58'),
(11, 'Transport', 'transport', 1, 0, '2018-06-27 11:21:26'),
(12, 'Hostel', 'hostel', 1, 1, '2022-09-14 07:17:47'),
(13, 'Communicate', 'communicate', 1, 0, '2018-07-02 11:20:00'),
(14, 'Reports', 'reports', 1, 1, '2018-06-27 07:10:22'),
(15, 'System Settings', 'system_settings', 1, 1, '2018-06-27 07:10:28'),
(16, 'Front CMS', 'front_cms', 1, 1, '2022-09-14 07:17:26'),
(17, 'Front Office', 'front_office', 1, 1, '2022-09-14 07:17:23'),
(18, 'Human Resource', 'human_resource', 1, 1, '2018-06-27 07:11:02'),
(19, 'Homework', 'homework', 1, 0, '2018-06-27 04:19:38'),
(20, 'Certificate', 'certificate', 1, 1, '2022-09-14 07:17:11'),
(21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '2018-06-27 07:12:25'),
(22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '2018-06-27 07:11:17');

-- --------------------------------------------------------